/* -*-  Mode: C++; c-file-style: "gnu"; indent-tabs-mode:nil; -*- */
/*
 * Author: Yu Cao <caoyu08@csnet1.cs.tsinghua.edu.cn>
 */


#ifndef NAMPT_CC_H
#define NAMPT_CC_H

#include "tcp-socket-base.h"

namespace ns3 {

/**
 * \ingroup socket
 * \ingroup tcp
 *
 * \brief An implementation of NaMPT Congestion Control Algorithm.
 *
 * we do not detect for idleness and thus no slow start upon resumption.
 */
class NaMPTCC : public TcpSocketBase
{
public:
  static TypeId GetTypeId (void);

  NaMPTCC (void);
  NaMPTCC (const NaMPTCC& sock);
  NaMPTCC (const TcpSocketBase& sock);
  virtual ~NaMPTCC (void);

  // From TcpSocketBase
  //virtual int Connect (const Address &address);
  virtual int Listen (void);

protected:
  virtual uint32_t Window (void); // Return the max possible number of unacked bytes
  virtual Ptr<TcpSocketBase> Fork (void); // Call CopyObject<NaMPTCC> to clone me
  virtual void NewAck (const SequenceNumber32& seq); // Inc cwnd and call NewAck() of parent
  virtual void DupAck (const TcpHeader& t, uint32_t count);  // Fast retransmit
  virtual void Retransmit (void); // Retransmit timeout

  // Implementing ns3::TcpSocket -- Attribute get/set
  //virtual void     SetSegSize (uint32_t size);
  virtual void     SetSSThresh (uint32_t threshold);
  virtual uint32_t GetSSThresh (void) const;
  virtual void     SetInitialCwnd (uint32_t cwnd);
  virtual uint32_t GetInitialCwnd (void) const;
private:
friend class NaMPTSocket;
friend class NaMPTSubflow;
  void InitializeCwnd (void);            // set m_cWnd when connection starts

protected:
  TracedValue<uint32_t>  m_cWnd;         //< Congestion window
  uint32_t               m_ssThresh;     //< Slow Start Threshold
  uint32_t               m_initialCWnd;  //< Initial cWnd value
  bool                   m_inFastRec;    //< currently in fast recovery

  // Notify NaMPTSocket
  Callback<bool, Ptr<NaMPTCC>, const SequenceNumber32& >
  								m_notifyNewAck;
  Callback<bool, Ptr<NaMPTCC>, const SequenceNumber32&, uint32_t>
  								m_notifyDupAck;
  Callback<bool, Ptr<NaMPTCC> >	m_notifyTimeout;
};

} // namespace ns3

#endif /* NAMPT_CC_H */
