/*
 * MPTCP ECN-based congestion control interface
 */
#ifndef __MPTCP_XMP_H
#define __MPTCP_XMP_H 1

#include <net/sock.h>
#include <linux/skbuff.h>


#define HIPQUAD(addr) \
	((unsigned char *)&addr)[3], \
	((unsigned char *)&addr)[2], \
	((unsigned char *)&addr)[1], \
	((unsigned char *)&addr)[0]
#define NIPQUAD(addr) \
	((unsigned char *)&addr)[0], \
	((unsigned char *)&addr)[1], \
	((unsigned char *)&addr)[2], \
	((unsigned char *)&addr)[3]

#define MPTCP_XMP_STATE_NORMAL ((u8)0)
#define MPTCP_XMP_STATE_CWND_REDUCED ((u8)1)

#define MPTCP_XMP_SCALE 16

/* Private Variables */
struct mptcp_xmp {
	u32 beg_seq; // per RTT tag
	u64 instant_rate; // cwnd / srtt_us, unit: pkts/us * 2^16
	s32 srtt_us; // smoothed rtt in the granularity of microseconds
	s32 baseRTT_us; // minimal rtt up to now
	s32 minRTT_us; // minimal rtt during the last round
	s16 cnt_ece; // the number of ECE on the side of senders
	u8 cnt_ce; //  the number of received Congestion Experience codepoint on the side of receivers
	u8 state; // 0: normal, 1: cwnd reduced
	u64 weight; // the ratio of subflow's rate to the total rate, * 2^16
	u32 adder; //  the remained number of packets by which cwnd should be increased, pkts * 2^16
	u64 alpha; //  the average ratio of the number of marked packets to cwnd, * 2^16
	u32 cwr_seq; // the snd_nxt when receiving the first ece
	u32 old_cwnd; // the cwnd before last reduction
	void (*receive_ece)(struct sock *sk, struct sk_buff *skb);
	void (*send_ece)(struct sock *sk, struct sk_buff *skb);
};


extern void mptcp_xmp_init(struct sock *sk);
extern void mptcp_xmp_release(struct sock *sk);
extern void mptcp_xmp_pkts_acked(struct sock *sk, u32 cnt, s32 rtt_us);
extern void mptcp_xmp_set_state(struct sock *sk, u8 ca_state);
extern void mptcp_xmp_cwnd_event(struct sock *sk, enum tcp_ca_event event);

#endif	/* __MPTCP_XMP_H */
